function meqmsge(mode,callfct,tok,t,it,shot,txt,mnem)
% Display errors/warnings/information during meqt run-time
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Display full iteration state 
if     numel(it)==1, it = sprintf('%d' ,it);
elseif numel(it)==2, it = sprintf('%d.%d',it(1),it(2));
else,                error('MEQMSGE:sizeIt', 'Unsupported number of elements in it');
end

msgID = sprintf('%s:%s',callfct,mnem);
if isscalar(t)
  msg = sprintf('%s#%d %6.4fs/%s: %s',tok,shot,t,it,txt);
else
  msg = sprintf('%s#%d %6.4f-%6.4fs/%s: %s',tok,shot,t(1),t(end),it,txt);
end

switch mode
  case 'i'
    disp(msg); %#ok<*DSPS,*SPWRN,*SPERR>
  case 'w'
    s = warning('off','backtrace');
    warning(msgID,msg);
    warning(s);
  case 'e'
    ME = MException(msgID,msg);
    throwAsCaller(ME);
end
end
