%MEQLARG  Make a structure with arguments
% MEQLARG(P1,...) returns a structure with fields corresponding to the name
% of the passed variables P1,... and assigns P1,... to those fields. Note
% that it cannot take expressions as arguments. When called with a
% structure as first argument, it adds the fields to that structure.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function S = meqlarg(varargin)
 if nargin && isstruct(varargin{1})
  S = varargin{1};
  k = 2;
 else
  k = 1;
 end
 for k = k:nargin
  S.(inputname(k)) = varargin{k};
 end