function meqinfo(L,LX)
% Display information about meq run parameters
% For now works only for FGE and FGS
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

fprintf('\n *** %s ***\n',upper(L.code));
fprintf('  Tokamak: %s, shot#%d, t=%3.3f\n',L.P.tokamak,LX.shot(1),LX.t(1))
if isfield(L.P,'lin') && L.P.lin && strcmp(L.code,'fge')
  fprintf('  Solver: linear\n')
else
  fprintf('  Solver: %s + %s\n',L.P.algoNL,L.P.algoF)
  if isequal(L.P.algoF,'jfnk')
    fprintf('  GMRES: %s\n',L.P.algoGMRES)
    fprintf('  prec:%d, mkryl:%d, kmax:%d\n',L.P.usepreconditioner,L.P.mkryl,L.P.kmax);
  else
    fprintf('  prec:%d\n',L.P.usepreconditioner);
  end
  fprintf('  tolF:%9.3e\n',L.P.tolF);
end

fprintf('  Vessel:%s, nu:%d\n',L.P.selu,L.G.nu);
fprintf('  Doublet: %d\n',L.P.idoublet);
if strcmp(L.code,'fge')
  fprintf('  CDE: %s\n',L.P.cde);
end
fprintf('  Constraints: \n')
fprintf('    Fun    iD       LXfield     ag index \n');
fprintf('   ----------------------------------- \n');disp(L.agconc);
fprintf('\n\n');
end
