function meqdebug(L,LYt,it)
% MEQDEBUG Display time loop debugging information
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

isFGElin = strcmp(L.code,'fge') && L.P.lin;

if nargin<2
  % Column headers
  nbytes = fprintf(  '\n  %8s | %3s | %7s | %6s | %6s | %6s | %6s', ...
    't','it', 'Ip [kA]' ,'zA[m]','rA[m]','bp','qA');
  if ~isFGElin
    nbytes = nbytes + fprintf(  ' | %5s | %6s | %4s | %8s', ...
      'niter','nfeval','conv', 'res');
  end
  fprintf('\n  %s\n',repmat('=',nbytes-3,1));
else
  % Actual data
  if LYt.nA
    % Plasma
    fprintf(  '  %8.5f | %3d | %7.2f | %6.3f | %6.3f | %6.3f | %6.3f',...
      LYt.t,it,LYt.Ip/1e3,LYt.zA(1),LYt.rA(1),LYt.bp,LYt.qA(1));
  else
    % Vacuum
    fprintf(  '  %8.5f | %3d | %7.2f | %6.3f | %6.3f | %6.3f | %6.3f',...
      LYt.t,it,LYt.Ip/1e3,NaN,NaN,NaN,NaN);
  end
  if ~isFGElin
    fprintf(  ' | %5d | %6d | %4d | %8.2e',...
      LYt.niter,LYt.nfeval,LYt.isconverged,LYt.res);
  end
  fprintf('\n');
end
