function argoutc = meqargoutc(argout,argoutc_)
% MEQARGOUTC Parses string for additional output argument specification
%
%   ARGOUTC = MEQARGOUTC(ARGOUT,ARGOUTC_)
%
% Parses cell array of strings ARGOUT assuming {'[file:]fld[=exp]',...} format.
% The output ARGOUTC is a cell array of structures with fields FILE, FLD and EXP.
% If FILE is not specified, the expression will be evaluated when LY is
% assembled by the main code file (e.g. LIUT,FBTT...)
% The processing of ARGOUT is appended to the preexisting list ARGOUTC_
% when provided.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

argout = reshape(cellstr(argout),1,[]); % Convert to cell row vector
% Parse argout parameter with value {'[file:]fld[=exp]' ...}
argoutc = regexp(argout,'(?<file>\w+:)*(?<fld>\w+)=*(?<exp>.+)*','names');
for ii = 1:numel(argoutc)
  if ~isempty(argoutc{ii}.file)
    % Remove colon
    argoutc{ii}.file = argoutc{ii}.file(1:end-1);
    if ~ismember(argoutc{ii}.file,{'fgeF','meqpost','meqpostq'})
      error('meqargoutc:unsupportedFile','File %s is not supported for additional argument specification',argoutc{ii}.file);
    end
  end
  if isempty(argoutc{ii}.exp)
    % Case with no expression provided
    argoutc{ii}.exp = argoutc{ii}.fld; % fld=fld
  end
end

% Append to preexisting list
if nargin>1
  argoutc = [argoutc_,argoutc];
end

end
