function LY = meqLYdot(LY,LYp)
% MEQLYDOT Computation of time derivatives of Bm,Ff,Fn measurements,
% respectively Um,Uf,Un
%
% Inputs
%  LY,LYp: current and previous LY structure.
% Output: 
%  LY: Input LY with appended Um,Uf,Un fields.
%
% NB: If LY.t = LYp.t Um,Uf and Un will be vectors of zeros.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

if LY.t == LYp.t
  LY.Um = zeros(size(LY.Bm));
  LY.Uf = zeros(size(LY.Ff));
  LY.Un = zeros(size(LY.Fn));
else
  idt = 1./(LY.t-LYp.t);
  LY.Um = (LY.Bm-LYp.Bm)*idt;
  LY.Uf = (LY.Ff-LYp.Ff)*idt;
  LY.Un = (LY.Fn-LYp.Fn)*idt;
end
end