function [dIydr,dIydz] = meqIyfd(Iy,Tzd,Trd)
% [dIydr,dIydz] = meqIyfd(Iy,Tzd,Trd)
% Calculate the spatial derivative in the r and z direction of Iy using
% second order finite difference and assuming the value of Iy to be 0
% outside the grid
%
% Input: Iy: plasma current distribution in the y grid
%        Tzd: tridiagonal matrix for the finite difference in the z
%        direction such that dIydz = Tzd*Iy
%        Trd: tridiagonal matrix for the finite difference in the r
%        direction such that dIydr = Iy*Trd
%
% Output: dIydr: finite difference derivarive wrt r
%         dIydz: finite difference derivarive wrt z
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

  %derivatives wrt r
  dIydr = Iy*Trd;
  
  %derivatives wrt z
  dIydz = Tzd*Iy;
end