%PDOMMEX  Find plasma domain
% OPY = PDOMMEX(FX,FB,IP,OXY) returns a logical array flagging the points
% inside the plasma. FX is the flux map, FB the LCFS flux, IP has the sign
% of Ip and OXY is the X-points polygon. For IP>0, OPY =
% FX(2:end-1,2:end-1)>FB & OXY, for IP<0, OPY = FX(2:end-1,2:end-1)<FB &
% OXY.
%
% For details, see: [J-M. Moret et al. Fus.Eng.Des 2015], Section 2.3
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function varargout = pdommex(varargin) %#ok<STOUT>
 error('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
end
