function opts = optsF(varargin)
% OPTSF default value for F options
%
% OPTS = OPTSF(VARARGIN)
%
% Generate a structure for use by functions passed to SOLVEF. Optional arguments in name-value pairs
% provide values to the different fields which are false by default.
%
% Each function as input to solveF must have a signature
%   [res,LY,Jx,Ju,Jxdot,rowmask] = F(x,...)
%
% List of fields:
%  - dopost: compute post processing LY
%  - doplot: produce some debugging plots
%  - dojacx: compute Jx (jacobian matrix dres/dx)
%  - dojacu: compute Ju (jacobian matrix dres/du)
%  - dojacxdot: compute Jxdot (jacobian matrix dres/dxdot = -dt*dres/dxp)
%  - dojacF: return a function handle for Jx
%
% See also: solveF fgeF fgsF_GS
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

opts = struct('dodisp',false,'dopost',false,'doplot',false,'dojacx',false,'dojacu',false,'dojacxdot',false,'dojacF',false);

if mod(nargin,2), error('optsF:nargin','optsF arguments should come in name,value pairs');end
for ii=1:2:nargin
  opts.(varargin{ii}) = varargin{ii+1};
end
 
end
