%NFDBMEX  Normal flux derivative on boundary
% DNFC = NFDBMEX(FX) returns a vector with the normal difference
% 4*F(x+dx)-F(x+2dx) on the boundary (except the corners) of the grid of FX
% (stored as [F(2:nz-1,1) F(1,2) F(nz,2) ... F(2:nz-1,nr)]). See also
% MEQMESH
%
% For details, see: [J-M. Moret et al. Fus.Eng.Des 2015], Section 4.2 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function varargout = nfdbmex(varargin) %#ok<STOUT>
 error('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
end
