function varargout = n2k(varargin)
% N2K utility for handling concatenation of different quantities
%   [kNa,kNb,kNb,...,nN] = n2k(na,nb,nc,...)
% If a vector N is made of the concatenation of several subvectors a,b,c...
% of size na, nb, nc then N2K computes kNa,kNb,kNc...nN such that N is of
% size nN and we have N(kNa) = a, N(kNb) = b, N(kNc) = c ...
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

varargout = cell(1,nargin+1);
varargout{end} = 0;
for k = 1:nargin
  varargout{k} = varargout{end}+(1:varargin{k});
  varargout{end} = varargout{end} + varargin{k};
end
end