/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "mex.h"
# include "mkl.h"
/* function y = dot(u,v) */
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[]) {
# define Y plhs[0]
# define U prhs[0]
# define V prhs[1]
 int n = mxGetM(U)*mxGetN(U), m = mxGetM(V)*mxGetN(V);
	n = m > n ? n : m;
 Y = mxCreateDoubleMatrix(n, 1, mxREAL);
	vdMul(n,mxGetPr(U),mxGetPr(V),mxGetPr(Y));
}
