%LOCRMEX  Location of q surfaces
%
% This is the MATLAB equivalent implementation of mexc/locRmex.c.
% A more detailed help is available in LOCRMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function aR = locRmexm(aQ,iqQ,iqR,naR,NF)

if nargin < 5, NF = NaN; end % default
if nargin < 4, naR = 1; end % default
if naR<1, error('invalid naR<1'); end
nR = numel(iqR);
nQ = numel(iqQ);

assert(size(aQ,1)==nQ,...
  'aQ must have numel(iqQ) rows')
aR = repmat(NF,nR,naR); % default value for non-found points

aR(:) = locQ(aQ.',iqQ,iqR,naR,NF); % locQ expects aQ of size [nO,nQ]

end
