%IPMJMEX Interior point method for base function fitting
%
% This is the MATLAB equivalent implementation of libmeq/ipmj.c.
% A more detailed help is available in IPMJMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [Ie,aj,st] = ipmjmexm(uAjj,Aje,Aej,Ie0,aj0,Ie_,aj_,Qcj,Xc,s,z,tol,iters)
 Ie = Ie_;
 aj1 = aj_;
 for kit = 1:iters
  aj2 = aj0+Aje*Ie;
  % Do a single IPM iteration
  [aj,s,z,~,st] = ipm2mexm(uAjj,aj2,Qcj,Xc,aj1,s,z,tol*1e6,1,false);
  Ie = Ie0 + Aej*aj;
  st = st && norm(aj-aj1,Inf) < tol;
  if st, break, end
  aj1 = aj;
 end
end
