%FSGIMEX  Flux surface geometrical integrals
%
% This is the MATLAB equivalent implementation of libmeq/fsgi.c.
% A more detailed help is available in FSGIMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [Q0Q,Q1Q,Q2Q,Q3Q,Q4Q,iqQ,ItQ,LpQ,rbQ,Q5Q,SlQ] = ...
  fsgimexm(M1q,M2q,rq,irq,rA,FA,FB,BA,lX,rX,iTQ,idoq)
 hipi = 1/(2*pi);
 irA = 1/rA;
 FAB = FA - FB;
 sIp = sign(FAB);
 doq = 1/idoq;
 CA  = hipi*BA; C3 = 16*FAB^2; C5 = sIp*hipi*4*FAB;
 Cq = 4*idoq*FAB; CI = 2*FAB*doq/(pi*mu0);

 M3q = sqrt(M2q.*M1q);

 s1q =                      1.0./sum( rq.*M1q) ;
 s2q =                           sum(irq.*M1q) ;
 s3q =                           sum(irq.*M2q) ;
 s5q =                           sum(     M3q) ;
 s6q =                           sum( rq.*M3q) ;
 Q0Q = [irA                 s1q.*sum(     M1q)].';       % <1/R>
 Q1Q = [hipi*CA*irA hipi*Cq*s1q               ].';       % -dpsi/dV
 Q2Q = [irA*irA             s1q.*s2q          ].';       % <1/R^2>
 Q3Q = [0                C3*s1q.*s3q          ].';       % <|grad psi|^2/R^2>
 Q4Q = [0                C3*s1q.*sum( rq.*M2q)].';       % <|grad psi|^2>
 iqQ = [CA*rA                Cq./s2q          ].'.*iTQ;  % 1/q
 ItQ = [0                    CI.*s3q          ].';       % Ip
 LpQ = [0                    doq*s5q          ].';       % int(dlp)
 rbQ = [rA                  s6q./s5q          ].';       % int(Rdlp)/int(dlp)
 Q5Q = [0                C5*s1q.*s6q          ].';       % <|grad psi|/(2*pi)>
 SlQ = [0               2*pi*doq*s6q          ].';       % 2*pi*int(Rdlp)
 if lX % special cases for diverted plasmas
  irX = 1/rX;
  Q0Q(end) = irX;
  Q1Q(end) = 0;
  Q2Q(end) = irX*irX;
  Q3Q(end) = 0;
  Q4Q(end) = 0;
  iqQ(end) = 0;
  Q5Q(end) = 0;
 end
end
