%FSG2MEX  Flux surface geometrical integrals 2
%
% This is the MATLAB equivalent implementation of libmeq/fsg2.c.
% A more detailed help is available in FSGIMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [VQ,AQ] = fsg2mexm(aq,rA,crq,doq)

 C1 = 0.5*doq;
 C2 = 2*pi*doq;

 qaq = aq.*aq;
 s1q = sum(qaq.*(rA/2 + aq.*crq/3));
 s2q = sum(qaq                    );

 VQ  = [0 C2*s1q].';
 AQ  = [0 C1*s2q].';
end
