%FL4PMEX  Four point interpolation for the flux on the limiter
%
% This is the MATLAB equivalent implementation of libmeq/fl4p.c.
% A more detailed help is available in FL4PMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function  [Fl,drFl,dzFl] = fl4pmexm(Fx,kl,cl,FN)
nz = size(Fx,1);
Fl = Fx(kl+1   ).*cl(1,:)' + ...
     Fx(kl+nz+1).*cl(2,:)' + ...
     Fx(kl+nz+2).*cl(3,:)' + ...
     Fx(kl+2   ).*cl(4,:)';

if FN
  dFl = diff(Fl([end 1:end]));
  maskl = dFl .* dFl([2:end 1]) > 0 | (dFl - dFl([2:end 1])) * FN > 0;
  Fl(maskl) = FN;

  drFl = (Fx(kl+nz+1) - Fx(kl   +1)).*(cl(2,:)+cl(1,:))' + ...
         (Fx(kl+nz+2) - Fx(kl   +2)).*(cl(4,:)+cl(3,:))';
  dzFl = (Fx(kl   +2) - Fx(kl   +1)).*(cl(4,:)+cl(1,:))' + ...
         (Fx(kl+nz+2) - Fx(kl+nz+1)).*(cl(3,:)+cl(2,:))';

  drFl(maskl) = 0;
  dzFl(maskl) = 0;
else
  drFl = zeros(size(Fl));
  dzFl = drFl;
end

end
