%FBNDMEX find the flux and the limiting point of the LCFS
%
% This is the MATLAB equivalent implementation of libmeq/fbnd.c.
% A more detailed help is available in FBNDMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [FB,rB,zB,lB,lX,kB] = fbndmexm(Fl,rl,zl,FX,rX,zX,FN)

 if (FN > 0) % Ip < 0
   [FBX,kX] = min([FN;FX]); kX = kX-1;
   [FBl,kl] = min([FN;Fl]); kl = kl-1;
   lX = FBX < FBl;
 else        % Ip > 0
   [FBX,kX] = max([FN;FX]); kX = kX-1;
   [FBl,kl] = max([FN;Fl]); kl = kl-1;
   lX = FBX > FBl;
 end
 if (kX && lX)
   FB = FBX;
   rB = rX(kX);
   zB = zX(kX);
   lB = 1;
   kB = kX;
 elseif kl
   FB = FBl;
   rB = rl(kl);
   zB = zl(kl);
   lB = 1;
   kB = kl;
 else
   FB = FN;
   rB = 0;
   zB = 0;
   lB = 0;
   kB = 0;
 end

end