%BINTMEX 4-point bilinear interpolation
%
% This is the MATLAB equivalent implementation of libmeq/bint.c.
% A more detailed help is available in BINTMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function Fi = bintmexm(Fx,k,c)

nz = size(Fx,1);
Fi = Fx(k+1   ).*c(1,:)' + ...
     Fx(k+nz+1).*c(2,:)' + ...
     Fx(k+nz+2).*c(3,:)' + ...
     Fx(k+2   ).*c(4,:)';

end
