%BBOXMEX  Domain bounding box
%
% This is the MATLAB equivalent implementation of libmeq/bbox.c.
% A more detailed help is available in BBOXMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [B] = bboxmexm(O,x,y)

[nx,ny] = size(O);

init = true;
for jj = 1:ny
  yv = y(jj);
  for ii = 1:nx
    xv = x(ii);
    if O(ii,jj)
      if (init)
        xa = xv; xb = xv;
        ya = yv; yb = yv;
        init = false;
      else
        if     (xv < xa), xa = xv;
        elseif (xv > xb), xb = xv;end
        if     (yv < ya), ya = yv;
        elseif (yv > yb), yb = yv;end
      end
    end
  end
end
if (init)
  B = zeros(1,4);
else
  B = [xa,ya,xb,yb];
end