/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [Y1,Y2,Y3] = vizrmex(Fx,Opy,ry,iry,rBt,dr,dz) */

# define MEXNAME vizrmex

# define Y1   pout[0]
# define Y2   pout[1]
# define Y3   pout[2] 

# define FX   prhs[0]  /* double, def size=[nz,nr] */
# define OPY  prhs[1]  /* int8, size=(nz-2)*(nr-2) */
# define RY   prhs[2]  /* double, size=(nr-2) */
# define IRY  prhs[3]  /* double, size=(nr-2) */
# define RBT  prhs[4]  /* numeric, scalar */
# define DR   prhs[5]  /* numeric, scalar */
# define DZ   prhs[6]  /* numeric, scalar */

 CHECK_NARGIN_EQ(7);

 int nz=mxGetM(FX), nr=mxGetN(FX);

 CHECK_DOUBLE(FX);
 CHECK_INT8(OPY);
 CHECK_NUMEL(OPY,(nz-2)*(nr-2));
 CHECK_DOUBLE(RY);
 CHECK_NUMEL(RY,(nr-2));
 CHECK_DOUBLE(IRY);
 CHECK_NUMEL(IRY,(nr-2));
 CHECK_NUMERIC(RBT);
 CHECK_SCALAR(RBT);
 CHECK_NUMERIC(DR);
 CHECK_SCALAR(DR);
 CHECK_NUMERIC(DZ);
 CHECK_SCALAR(DZ);

 CHECK_NARGOUT_LE(3);

 mxArray *pout[3] = {NULL};
  
 Y1 = mxCreateDoubleMatrix(1,1,mxREAL);
 Y2 = mxCreateDoubleMatrix(1,1,mxREAL);
 Y3 = mxCreateDoubleMatrix(1,1,mxREAL);

 dvizr(mxGetPr(Y1),mxGetPr(Y2),mxGetPr(Y3),mxGetPr(FX),
       (int8_t *)mxGetData(OPY),mxGetPr(RY),mxGetPr(IRY),
       mxGetScalar(RBT),mxGetScalar(DR),mxGetScalar(DZ),nr,nz);

 ASSIGN_PLHS;
}
