/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* function b = uatamex(a) */

# define MEXNAME uatamex

# define B pout[0]

# define A prhs[0] /* double or single, def size=[m,n] */

 CHECK_NARGIN_EQ(1);

 CHECK_REAL(A);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};

 int m = mxGetM(A), n = mxGetN(A);
 switch (mxGetClassID(A)) {
  case mxDOUBLE_CLASS: {
   B = mxCreateDoubleMatrix(n*(n+1)/2, 1, mxREAL);
   duata(mxGetPr(B), mxGetPr(A), m, n);
   break;
  }
  case mxSINGLE_CLASS: {
   B = mxCreateNumericMatrix(n*(n+1)/2, 1, mxSINGLE_CLASS, mxREAL);
   suata((float*)mxGetData(B), (float*)mxGetData(A), m, n);
   break;
  }
  default:
   mexErrMsgIdAndTxt("uatamex:error","Class of A is neither double nor single but has passed the real test");
 }

 ASSIGN_PLHS;
}
