/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* y = respmex(a,b,c,d) */

# define MEXNAME respmex

# define Y pout[0]

# define A prhs[0] /* double or single, def size=[m,nA] */
# define B prhs[1] /* type match A, def size=[*,nB], size=[nA,nB] */
# define C prhs[2] /* type match A, def size=[*,nC], size=[ m,nC] */
# define D prhs[3] /* type match A, def size=[*,nD], size=[nC,nD] */

 CHECK_NARGIN_EQ(4);

 int nA = mxGetN(A);
 int nB = mxGetN(B);
 int nC = mxGetN(C);
 int nD = mxGetN(D);
 int m = mxGetM(A);

 CHECK_REAL(A);
 CHECK_TYPE_MATCH(B,A);
 CHECK_NROWS(B,nA);
 CHECK_TYPE_MATCH(C,A);
 CHECK_NROWS(C,m);
 CHECK_TYPE_MATCH(D,A);
 CHECK_NROWS(D,nC);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};
 
 switch (mxGetClassID(A)) {
  case mxDOUBLE_CLASS: {
   double *a = mxGetPr(A);
   double *b = mxGetPr(B);
   double *c = mxGetPr(C);
   double *d = mxGetPr(D);
   double *y = mxGetPr(Y = mxCreateDoubleMatrix(m, nB+nD, mxREAL));
   dresp(y, a, b, c, d, m, nA, nB, nC, nD);
   break;
  }
  case mxSINGLE_CLASS: {
   float *a = (float *)mxGetData(A);
   float *b = (float *)mxGetData(B);
   float *c = (float *)mxGetData(C);
   float *d = (float *)mxGetData(D);
   float *y = (float *)mxGetData(Y = mxCreateNumericMatrix(m, nB+nD, mxSINGLE_CLASS, mxREAL));
   sresp(y, a, b, c, d, m, nA, nB, nC, nD);
   break;
  }
  default:
   mexErrMsgIdAndTxt("respmex:error","Class of A is neither double nor single but has passed the real test");
 }

 ASSIGN_PLHS;
}
