/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
 
 /* [Opy] = pdommex(Fx,FB,Ip,OXy) */

# define MEXNAME pdommex

# define OPY  pout[0]

# define FX   prhs[0] /* double, def size=[nzy+2,nry+2] */
# define FB   prhs[1] /* numeric, scalar */
# define IP   prhs[2] /* numeric, scalar */
# define OXY  prhs[3] /* logical, size=[nzy,nry] */

 CHECK_NARGIN_EQ(4);

 int nzy = mxGetM(FX)-2, nry = mxGetN(FX)-2;

 CHECK_DOUBLE(FX);
 CHECK_NUMERIC(FB);
 CHECK_SCALAR(FB);
 CHECK_NUMERIC(IP);
 CHECK_SCALAR(IP);
 CHECK_LOGICAL(OXY);
 CHECK_NUMEL(OXY,nzy*nry);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};

 OPY = mxCreateLogicalMatrix(nzy,nry);
 
 dpdom((meq_bool *)mxGetLogicals(OPY), mxGetPr(FX), mxGetScalar(FB), mxGetScalar(IP), (meq_bool *)mxGetLogicals(OXY), nzy, nry);

 ASSIGN_PLHS;
}
