/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

  /* nfd = nfdbmex(f) */

# define MEXNAME nfdbmex

# define NFD pout[0]

# define F   prhs[0] /* double, def size=[nx,ny,ntot] */

  CHECK_NARGIN_EQ(1);

  CHECK_DOUBLE(F);

  CHECK_NARGOUT_LE(1);

  mxArray *pout[1] = {NULL};
  
  int nd = mxGetNumberOfDimensions(F);
  const mwSize *dims = mxGetDimensions(F);
  int nx = (int)dims[0];
  int ny = (int)dims[1];
  int ntot = nd>2 ? (int)dims[2] : 1;

  NFD = mxCreateDoubleMatrix(2*(nx-2)+2*(ny-2),ntot,mxREAL);
  dnfdb(mxGetPr(NFD),mxGetPr(F),nx,ny,ntot);

  ASSIGN_PLHS;
}
