/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [x,s,z,kt,stat] = ipm2mex(uH,c,A,b,x0,s0,z0,tol,nit,verb) */

# define MEXNAME ipm2mex

# define X   pout[0]
# define S   pout[1]
# define Z   pout[2]
# define KT  pout[3]
# define ST  pout[4]

# define H   prhs[0]  /* double, size=n*(n+1)/2 */
# define C   prhs[1]  /* double, def size=n */
# define A   prhs[2]  /* double, def size=[ni,*], size=[ni,n] */
# define B   prhs[3]  /* double, size=ni */
# define X0  prhs[4]  /* double, size=n */
# define S0  prhs[5]  /* double, size=ni */
# define Z0  prhs[6]  /* double, size=ni */
# define TOL prhs[7]  /* numeric, scalar */
# define NIT prhs[8]  /* numeric, scalar */
# define VRB prhs[9]  /* logical, scalar */

 CHECK_NARGIN_EQ(10);

 int n = mxGetNumberOfElements(C), ni = mxGetM(A);

 CHECK_DOUBLE(H);
 CHECK_NUMEL(H,n*(n+1)/2);
 CHECK_DOUBLE(C);
 CHECK_DOUBLE(A);
 CHECK_NCOLS(A,n);
 CHECK_DOUBLE(B);
 CHECK_NUMEL(B,ni);
 CHECK_DOUBLE(X0);
 CHECK_NUMEL(X0,n);
 CHECK_DOUBLE(S0);
 CHECK_NUMEL(S0,ni);
 CHECK_DOUBLE(Z0);
 CHECK_NUMEL(Z0,ni);
 CHECK_NUMERIC(TOL);
 CHECK_SCALAR(TOL);
 CHECK_NUMERIC(NIT);
 CHECK_SCALAR(NIT);
 CHECK_LOGICAL(VRB);
 CHECK_SCALAR(VRB);

 CHECK_NARGOUT_LE(5);

 mxArray *pout[5] = {NULL};
 
 int kt = 0;
 meq_bool stat = meq_false;
 double *w  = (double *)mxCalloc(n*(n+1)/2+2*n+6*ni,sizeof(double));
 X = mxCreateDoubleMatrix(n ,1,mxREAL);
 S = mxCreateDoubleMatrix(ni,1,mxREAL);
 Z = mxCreateDoubleMatrix(ni,1,mxREAL);

 dipm2(mxGetPr(X), mxGetPr(S), mxGetPr(Z), &kt, &stat, 
       mxGetPr(H), mxGetPr(C), mxGetPr(A), mxGetPr(B),
       mxGetPr(X0), mxGetPr(S0), mxGetPr(Z0),
       mxGetScalar(TOL), (int)mxGetScalar(NIT),
       mxIsLogicalScalarTrue(VRB), w, n, ni);

 KT = mxCreateDoubleScalar((double)kt);
 ST = mxCreateLogicalScalar(stat);
 mxFree(w);

 ASSIGN_PLHS;
}
