/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

  /* Fx = gszrmex(Fb,Jy,cx,cq,cr,cs,ci,co,dz) */

# define MEXNAME gszrmex

# define FX pout[0]

# define FB prhs[0] /* double, size=2*(nz-nr-2)*ntot */
# define JY prhs[1] /* double, def size=[nz-2,nr-2,ntot] */
# define CX prhs[2] /* double, size=(nr-2) */
# define CQ prhs[3] /* double, size=(nr-2)*(nz-2) */
# define CR prhs[4] /* double, size=(nr-2)*(nz-2) */
# define CS prhs[5] /* double, size=(nr-2)*(nz-2) */
# define CI prhs[6] /* numeric, scalar */
# define CO prhs[7] /* numeric, scalar */
# define DZ prhs[8] /* numeric, scalar */

  CHECK_NARGIN_EQ(9);
  
  int nd = mxGetNumberOfDimensions(JY);
  const mwSize *dims = mxGetDimensions(JY);
  int nz2 = (int)dims[0], nz = nz2+2;
  int nr2 = (int)dims[1], nr = nr2+2;
  int ntot = nd>2 ? (int)dims[2] : 1;
  
  CHECK_DOUBLE(FB);
  CHECK_NUMEL(FB,2*(nz2+nr)*ntot);
  CHECK_DOUBLE(JY);
  CHECK_DOUBLE(CX);
  CHECK_NUMEL(CX,nr2);
  CHECK_DOUBLE(CQ);
  CHECK_NUMEL(CQ,nr2*nz2);
  CHECK_DOUBLE(CR);
  CHECK_NUMEL(CR,nr2*nz2);
  CHECK_DOUBLE(CS);
  CHECK_NUMEL(CS,nr2*nz2);
  CHECK_NUMERIC(CI);
  CHECK_SCALAR(CI);
  CHECK_NUMERIC(CO);
  CHECK_SCALAR(CO);
  CHECK_NUMERIC(DZ);
  CHECK_SCALAR(DZ);

  CHECK_NARGOUT_LE(1);

  mxArray *pout[1] = {NULL};

  const mwSize Fxdims[3] = {nz,nr,ntot};
  double *fx = mxGetPr(FX = mxCreateNumericArray(3,Fxdims,mxDOUBLE_CLASS,mxREAL));
  double *fb = mxGetPr    (FB);
  double *jy = mxGetPr    (JY);
  double *cx = mxGetPr    (CX);
  double *cq = mxGetPr    (CQ);
  double *cr = mxGetPr    (CR);
  double *cs = mxGetPr    (CS);
  double  ci = mxGetScalar(CI);
  double  co = mxGetScalar(CO);
  double  dz = mxGetScalar(DZ);
  /* allocate nr-2 x nz-2 for parallelised gszr */
  double *p = (double *)mxCalloc(nr2*ntot,sizeof(double));
  dgszr(fx,fb,jy,cx,cq,cr,cs,ci,co,p,nz,nr,ntot,dz);

  ASSIGN_PLHS;
}
