/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /*  [VQ,AQ] = fsg2(aq,rA,crq,doq) */

# define MEXNAME fsg2mex

# define VQ   pout[ 0]
# define AQ   pout[ 1]

# define aq    prhs[ 0]  /* double, def size=[noq,npq] */
# define rA    prhs[ 1]  /* numeric, scalar */
# define crq   prhs[ 2]  /* double, size=noq */
# define doq   prhs[ 3]  /* numeric, scalar */

 CHECK_NARGIN_EQ(4);

 int noq = mxGetM(aq), npq = mxGetN(aq);

 CHECK_DOUBLE(aq);
 CHECK_NUMERIC(rA);
 CHECK_SCALAR(rA);
 CHECK_DOUBLE(crq);
 CHECK_NUMEL(crq,noq);
 CHECK_NUMERIC(doq);
 CHECK_SCALAR(doq);

 CHECK_NARGOUT_LE(2);

 mxArray *pout[2] = {NULL};

 VQ  = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 AQ  = mxCreateDoubleMatrix(npq+1,1,mxREAL);
 dfsg2(mxGetPr(VQ), mxGetPr(AQ),
       mxGetPr(aq), mxGetScalar(rA), mxGetPr(crq),
       mxGetScalar(doq), npq, noq);

 ASSIGN_PLHS;
}
