/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [FB,rB,zB,lB,lX,kB] = fbndmex(Fl,rl,zl,FX,rX,zX,FN) */

# define MEXNAME fbndmex

# define FB   pout[0]
# define RB   pout[1]
# define ZB   pout[2]
# define LB   pout[3]
# define LX   pout[4]
# define KB   pout[5]

# define FL   prhs[0]  /* double, def size=nL */
# define RL   prhs[1]  /* double, size=nL */
# define ZL   prhs[2]  /* double, size=nL */
# define FX   prhs[3]  /* double, def size=nX */
# define RX   prhs[4]  /* double, size=nX */
# define ZX   prhs[5]  /* double, size=nX */
# define FN   prhs[6]  /* numeric, scalar */

 CHECK_NARGIN_EQ(7);

 int nX = mxGetNumberOfElements(FX);
 int nL = mxGetNumberOfElements(FL);

 CHECK_DOUBLE(FL);
 CHECK_DOUBLE(RL);
 CHECK_NUMEL(RL,nL);
 CHECK_DOUBLE(ZL);
 CHECK_NUMEL(ZL,nL);
 CHECK_DOUBLE(FX);
 CHECK_DOUBLE(RX);
 CHECK_NUMEL(RX,nX);
 CHECK_DOUBLE(ZX);
 CHECK_NUMEL(ZX,nX);
 CHECK_NUMERIC(FN);
 CHECK_SCALAR(FN);

 CHECK_NARGOUT_LE(6);

 mxArray *pout[6] = {NULL};
 
 FB = mxCreateDoubleMatrix(1,1,mxREAL);
 RB = mxCreateDoubleMatrix(1,1,mxREAL);
 ZB = mxCreateDoubleMatrix(1,1,mxREAL);
 LB = mxCreateLogicalMatrix(1,1);
 LX = mxCreateLogicalMatrix(1,1);
 KB = mxCreateNumericMatrix(1,1,mxINT32_CLASS,mxREAL);
 
 dfbnd(mxGetPr(FB), mxGetPr(RB), mxGetPr(ZB), (meq_bool *)mxGetLogicals(LB), (meq_bool *)mxGetLogicals(LX),
       (int *) mxGetData(KB),
       mxGetPr(FL), mxGetPr(RL), mxGetPr(ZL),
       mxGetPr(FX), mxGetPr(RX), mxGetPr(ZX), nX, mxGetScalar(FN), nL);

 ASSIGN_PLHS;
}
