/* CIZRMEX Compute custom plasma cross-section integrals
 *   See description in cizrmex.m */

/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [IVQD] = cizrmex(Fx,Opy,Vy,dsx,FNQ,F0,F1) */

# define MEXNAME cizrmex

# define IVQD pout[0] 

# define FX   prhs[0]  /* double, def size=[nz,nr] */
# define OPY  prhs[1]  /* int8, size=(nz-2)*(nr-2) */
# define VY   prhs[2]  /* double, def size=[(nz-2)*(nr-2),nV] */
# define DS   prhs[3]  /* numeric, scalar */
# define FNQ  prhs[4]  /* double, def size=nQ */
# define F0   prhs[5]  /* double, def size=nD */
# define F1   prhs[6]  /* double, size=nD */

 CHECK_NARGIN_EQ(7);

 int nz=mxGetM(FX), nr=mxGetN(FX),
     nV=mxGetN(VY),
     nQ=mxGetNumberOfElements(FNQ),
     nD=mxGetNumberOfElements(F0);
 
 int ny = (nz-2)*(nr-2);

 CHECK_DOUBLE(FX);
 CHECK_INT8(OPY);
 CHECK_NUMEL(OPY,ny);
 CHECK_DOUBLE(VY);
 CHECK_NROWS(VY,ny);
 CHECK_NUMERIC(DS);
 CHECK_SCALAR(DS);
 CHECK_DOUBLE(FNQ);
 CHECK_DOUBLE(F0);
 CHECK_DOUBLE(F1);
 CHECK_NUMEL(F1,nD);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};
 
 const mwSize dims[3] = {nQ,nD,nV};
 IVQD = mxCreateNumericArray(3,dims,mxDOUBLE_CLASS,mxREAL);

 dcizr(mxGetPr(IVQD),mxGetPr(FX),
       (int8_t *)mxGetData(OPY),mxGetPr(VY),mxGetScalar(DS),
       mxGetPr(FNQ),mxGetPr(F0),mxGetPr(F1),nV,nQ,nD,nr,nz);

 ASSIGN_PLHS;
}
