/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [FI] = bint(FX,K,C) */

# define MEXNAME bintmex

# define FI pout[0]

# define FX prhs[0]  /* double, def size=[nz,*] */
# define K  prhs[1]  /* int32, def size=ni */
# define C  prhs[2]  /* double, size=4*ni */

 int ni, nz;
 
 CHECK_NARGIN_EQ(3);
 
 ni = mxGetNumberOfElements(K);
 nz = mxGetM(FX);

 CHECK_DOUBLE(FX);
 CHECK_INT32(K);
 CHECK_DOUBLE(C);
 CHECK_NUMEL(C,4*ni);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};
 
 FI = mxCreateDoubleMatrix(ni,1,mxREAL);

 dbint(mxGetPr(FI), mxGetPr(FX), (int*)mxGetData(K), mxGetPr(C), ni, nz);

 ASSIGN_PLHS;
}
