/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */


/*
 * bfabmex.c is a MEX-file for the C implementation of the bfab set
 *
 * See also: bfctmex.h bfab.c bfab.m
 */

# include "meq.h"

# define MEXNAME bfabmex

# include "bfctmex.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

  /* Declare potential output arguments */
  mxArray *pout[NARGOUT_MAX] = {NULL};

  /* Initial checks */
  bfctmex_init_checks(nlhs, pout, nrhs, prhs);

  /* Parameter checks */
  CHECK_DOUBLE(par);
  CHECK_NUMEL(par,2);

  /* Get parameters and number of basis functions */
  int nP = mxGetPr(par)[0],
      nT = mxGetPr(par)[1];
  int ng = nP+nT;

  /* Get fPg and fTg */
  double fPg[ng], fTg[ng];
  dbfab_fPg(nP, nT, fPg, fTg);

  /* Define parameter structure for bfab */
  bfab_params bfparams = {nP, nT};

  /* Define parameter structure for bfct */
  dbfct_params params = {ng, fPg, fTg, &bfparams, dbfab_f , dbfab_fN , dbfab_fag , dbfab_fA ,
                                                  dbfab_df, dbfab_dfN, dbfab_dfag, dbfab_dfA};

  /* Get mode value */
  int mode = mxGetScalar(MODE);

  /* Chinese menu */
  switch (mode) {
    case 6: {
      int nPq = nP ? nP-1 : 0, nTq = nT ? nT-1 : 0, nq = nPq + nTq;

      /* Inputs checks */
      bfctmex_mode_6_checks_alloc(nlhs, pout, nrhs, prhs, ng, nq);

      /* Call bfab */
      dbfab6(mxGetPr(y1), mxGetPr(y2), mxGetScalar(FA), mxGetScalar(FB),
             mxGetScalar(q1), mxGetScalar(q2), mxGetScalar(q3), nP, nT, nq);
      break;
    }
    case 7: {
      int nPc = nP==3 ? 2 : nP, nTc = 0, nc = nPc + nTc;

      /* Inputs checks */
      bfctmex_mode_7_checks_alloc(nlhs, pout, nrhs, prhs, ng, nc);

      /* Call bfab */
      dbfab7(mxGetPr(y1), mxGetPr(y2), mxGetScalar(FA), mxGetScalar(FB),
             nP, nT, nc);
      break;
    }
    case 16: {
      int nPq = nP ? nP-1 : 0, nTq = nT ? nT-1 : 0, nq = nPq + nTq;

      /* Inputs checks */
      bfctmex_mode_16_checks_alloc(nlhs, pout, nrhs, prhs, ng, nq);

      /* Call bfab */
      dbfab16(mxGetPr(y1), mxGetPr(y2), mxGetPr(y3), mxGetPr(y4),
              mxGetScalar(FA), mxGetScalar(FB), mxGetScalar(q1),
              mxGetScalar(q2), mxGetScalar(q3), nP, nT, nq);
      break;
    }
    case 17: {
      int nPc = nP==3 ? 2 : nP, nTc = 0, nc = nPc + nTc;

      /* Inputs checks */
      bfctmex_mode_17_checks_alloc(nlhs, pout, nrhs, prhs, ng, nc);

      /* Call bfab */
      dbfab17(mxGetPr(y1), mxGetPr(y2), mxGetScalar(FA), mxGetScalar(FB),
              nP, nT, nc);
      break;
    }
    default: {
      /* Call generic bfctmex */
      bfctmex(mode, &params, nlhs, pout, nrhs, prhs);
    }
  }

  ASSIGN_PLHS;
}
