/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */


/*
 * bf3pmex.c is a MEX-file for the C implementation of the bf3p set
 *
 * See also: bfctmex.h bf3p.c
 */

# include "meq.h"

# define MEXNAME bf3pmex

# include "bfctmex.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

  /* Declare potential output arguments */
  mxArray *pout[NARGOUT_MAX] = {NULL};

  /* Initial checks */
  bfctmex_init_checks(nlhs, pout, nrhs, prhs);

  /* Parameter checks */
  CHECK_LOGICAL(par);
  CHECK_SCALAR(par);

  /* Get number of basis functions */
  int ng = 3;

  /* Get fPg and fTg */
  double fPg[ng], fTg[ng];
  dbf3p_fPg(fPg, fTg);

  /* Define parameter structure for bf3p */
  bf3p_params bfparams = {mxIsLogicalScalarTrue(par)};

  /* Define parameter structure for bfct */
  dbfct_params params = {ng, fPg, fTg, &bfparams, dbf3p_f , dbf3p_fN , dbf3p_fag , dbf3p_fA ,
                                                  dbf3p_df, dbf3p_dfN, dbf3p_dfag, dbf3p_dfA};

  /* Get mode value */
  int mode = mxGetScalar(MODE);

  /* Chinese menu */
  switch (mode) {
    case 0 : {
      double one = 1.0;

      /* Inputs checks */
      bfctmex_mode_0_checks_alloc(nlhs, pout, nrhs, prhs, ng);

      /* Compute fPg and fTg */
      double *fPg = mxGetPr(y1);
      double *fTg = mxGetPr(y2);
      fPg[0] = 1.0; fPg[1] = fPg[2] = 0.0;
      fTg[0] = 0.0; fTg[1] = fTg[2] = 1.0;
      /* Set TDg = 1.0 */
      SET(ng,mxGetPr(y3),one);
      break;
    }
    case 1 : {
      int nzy, nry;

      /* Inputs checks */
      bfctmex_mode_1_checks_alloc(nlhs, pout, nrhs, prhs, ng, &nzy, &nry);

      /* Call bf3p */
      dbf3p1(mxGetPr(y1), mxGetPr(y2), mxGetPr(y3),
             mxGetPr(u1), mxGetScalar(FA), mxGetScalar(FB),
             (int8_t *)mxGetData(q1), mxGetPr(q2), mxGetPr(q3),
             nzy, nry,
             mxIsLogicalScalarTrue(par), 0);
      break;
    }
    case 2: {
      int nQ;

      /* Inputs checks */
      bfctmex_mode_2_checks_alloc(nlhs, pout, nrhs, prhs, ng, &nQ);

      /* Call bf3p */
      dbf3p2(mxGetPr(y1), mxGetPr(y2), mxGetPr(u1), nQ);
      break;
    }
    case 3: {
      /* Inputs checks */
      bfctmex_mode_3_checks_alloc(nlhs, pout, nrhs, prhs, ng);

      /* Call bf3p */
      dbf3p3(mxGetPr(y1), mxGetPr(y2), mxGetPr(y3), mxGetPr(y4),
             mxGetPr(u1), mxGetScalar(FA), mxGetScalar(FB),
             mxGetScalar(q3));
      break;
    }
    case 5: {
      /* Inputs checks */
      bfctmex_mode_5_checks_alloc(nlhs, pout, nrhs, prhs, ng);

      /* Call bf3p */
      dbf3p5(mxGetPr(y1), mxGetPr(y2), mxGetScalar(FA), mxGetScalar(FB),
             mxIsLogicalScalarTrue(par));
      break;
    }
    case 6: {
      int nq = 1;

      /* Inputs checks */
      bfctmex_mode_6_checks_alloc(nlhs, pout, nrhs, prhs, ng, nq);

      /* Call bf3p */
      dbf3p6(mxGetPr(y1), mxGetPr(y2), mxGetScalar(FA), mxGetScalar(FB),
             mxGetScalar(q2),  mxGetScalar(q3));
      break;
    }
    case 7: {
      int nc = 0;

      /* Inputs checks */
      bfctmex_mode_7_checks_alloc(nlhs, pout, nrhs, prhs, ng, nc);

      /* Do not call bf3p as nc=0 so far */
      break;
    }
    case 8: {
      int nzy, nry;

      /* Inputs checks */
      bfctmex_mode_8_checks_alloc(nlhs, pout, nrhs, prhs, ng, &nzy, &nry);

      /* Call bf3p */
      dbf3p8(mxGetPr(y1), mxGetPr(u1), mxGetScalar(FA), mxGetScalar(FB),
             (int8_t *)mxGetData(q1), mxGetPr(q2), mxGetScalar(q3),
             mxIsLogicalScalarTrue(par), mxGetScalar(q4), mxGetPr(q5), nzy, nry);
      break;
    }
    case 16: {
      int nq = 1;

      /* Inputs checks */
      bfctmex_mode_16_checks_alloc(nlhs, pout, nrhs, prhs, ng, nq);

      /* Call bf3p */
      dbf3p16(mxGetPr(y1), mxGetPr(y2), mxGetPr(y3), mxGetPr(y4),
              mxGetScalar(FA), mxGetScalar(FB), mxGetScalar(q2), mxGetScalar(q3));
      break;
    }
    default: {
      /* Call generic bfctmex */
      bfctmex(mode, &params, nlhs, pout, nrhs, prhs);
    }
  }

  ASSIGN_PLHS;
}
