/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */


/*
 * bf3imex.c is a MEX-file for the C implementation of the bf3i set
 *
 * See also: bfctmex.h bf3i.c
 */

# include "meq.h"

# define MEXNAME bf3imex

# include "bfctmex.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

  /* Declare potential output arguments */
  mxArray *pout[NARGOUT_MAX] = {NULL};

  /* Initial checks */
  bfctmex_init_checks(nlhs, pout, nrhs, prhs);

  /* Parameter checks */
  CHECK_SCALAR(par);

  mxArray  *gNg = mxGetField(par,0, "gNg");
  mxArray *IgNg = mxGetField(par,0,"IgNg");
  mxArray  *fPg = mxGetField(par,0, "fPg");
  mxArray  *fTg = mxGetField(par,0, "fTg");

  if ( gNg==NULL || IgNg==NULL || fPg==NULL || fTg==NULL )
    mexErrMsgIdAndTxt(MEXARGS_STR(MEXNAME)":fields","Error getting parameter fields, check input field names");

  CHECK_DOUBLE(gNg);
  int nN = mxGetM(gNg);
  CHECK_NCOLS(gNg,3);
  CHECK_DOUBLE(IgNg);
  CHECK_NROWS(IgNg,nN);
  CHECK_NCOLS(IgNg,3);
  CHECK_DOUBLE(fPg);
  CHECK_NUMEL(fPg,3);
  CHECK_DOUBLE(fTg);
  CHECK_NUMEL(fTg,3);

  /* Get number of basis functions */
  int ng = 3;

  /* Define parameter structure for bf3i */
  dbf3i_params bfparams = {mxGetPr(gNg), mxGetPr(IgNg), nN};

  /* Define parameter structure for bfct */
  dbfct_params params = {ng, mxGetPr(fPg), mxGetPr(fTg), &bfparams, dbf3i_f , dbf3i_fN , dbf3i_fag , dbf3i_fA ,
                                                                    dbf3i_df, dbf3i_dfN, dbf3i_dfag, dbf3i_dfA};

  /* Get mode value */
  int mode = mxGetScalar(MODE);

  /* Chinese menu */
  switch (mode) {
    case 6: {
      int nq = 1;

      /* Inputs checks */
      bfctmex_mode_6_checks_alloc(nlhs, pout, nrhs, prhs, ng, nq);

      /* Call bf3i */
      dbf3i6(mxGetPr(y1), mxGetPr(y2));
      break;
    }
    case 16: {
      int nq = 1;

      /* Inputs checks */
      bfctmex_mode_16_checks_alloc(nlhs, pout, nrhs, prhs, ng, nq);

      /* Call bf3i */
      dbf3i16(mxGetPr(y1), mxGetPr(y2), mxGetPr(y3), mxGetPr(y4));
      break;
    }
    default: {
      /* Call generic bfctmex */
      bfctmex(mode, &params, nlhs, pout, nrhs, prhs);
    }
  }

  ASSIGN_PLHS;
}
