/* [+MEQ MatlabEQuilibrium Toolbox+]
 *
 *    Copyright 2022-2025 Swiss Plasma Center EPFL
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License. */

# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [x1 y1 x2 y2] = bboxmex(lxy,x,y) */

# define MEXNAME bboxmex

# define B pout[0]

# define L prhs[0]  /* logical, def size=[nx,ny] */
# define X prhs[1]  /* double, size=nx */
# define Y prhs[2]  /* double, size=ny */

 CHECK_NARGIN_EQ(3);
 
 int nx = mxGetM(L), ny = mxGetN(L);

 CHECK_LOGICAL(L);
 CHECK_DOUBLE(X);
 CHECK_NUMEL(X,nx);
 CHECK_DOUBLE(Y);
 CHECK_NUMEL(Y,ny);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};

 double *bp = mxGetPr(B = mxCreateDoubleMatrix(1,4,mxREAL));
 dbbox(bp, bp+1, bp+2, bp+3, (meq_bool *)mxGetLogicals(L), mxGetPr(X), mxGetPr(Y), nx, ny);

 ASSIGN_PLHS;
}
