function X = meqxfile(t,L)
% MEQXFILE - Input data for FILE
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

X = load(L.P.xfile);

%% Select time indices for our t array
if isempty(t), t=X.t; end
assert(~any( t>max(X.t) | t<min(X.t)),...
  'requested times [%4.2f,%4.2f] are out of range of available time [%4.2f,%4.2f]',...
      min(t),max(t),min(X.t),max(X.t));

% Interpolate
X = meqinterp(meqxk(X,1:numel(X.t)),t,L.P.interpmethod);

end
