function LX = meqx(L,LX)
% General LX quantities
% For help on most quantities, see help MEQT
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% reorder fields to have these first:
D.tokamak  = L.P.tokamak;
D.shot     = L.P.shot;

for field=fieldnames(D)'
  if ~isfield(LX,field{1})
    LX.(field{1}) = D.(field{1});
  end
end

if ~isfield(LX,'aq'), LX.aq = []; end
if ~isfield(LX,'aW'), LX.aW = []; end

firstfields = {'tokamak','shot','t'};
LX = orderfields(LX,[firstfields,setdiff(fieldnames(LX)',firstfields)]);

end