function LY = meqsk(LY,k,LX)
%MEQSK substitute LY time slice
%
% LY = meqsk(LY,k,LX)
% Substitutes LY data at index k by LX slice(s)
% LX must have a number of times equal one, or to the number of indices k.
% k can be logical or numerical index
%
% See also: MEQIK, MEQXK
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

if islogical(k); k=find(k); end

if numel(LX.t)==1 && numel(k)>1
  % copy single slice as often as needed
  LX = meqlpack(repmat(LX,1,numel(k)));
end
if numel(LX.t)~=numel(k)
  error('number of slices in LXt (%d) does not match indices in k (%d)',numel(LX.t),numel(k))
end

for ik=1:numel(k)
  
  for ifield = fieldnames(LX)'
    myfield = ifield{:};
    switch myfield
      case {'shot','tokamak'}
        % do nothing
      case {'Fx','Iy','Opy'}
        LY.(myfield)(:,:,k(ik)) = LX.(myfield)(:,:,ik);
        % handle these directly
      otherwise
        
        LXfield = LX.(myfield);
        
        if ~isfield(LY,myfield)
          if k~=1, error('can not assign non-existing field other than at first index'); end
          LY.(myfield) = LXfield;
        else
          LYfield = LY.(myfield); % base size decision on target field
          if isa(LYfield,'logical'), defaultvalue = false;
          else, defaultvalue  = nan;
          end
          
          if isempty(LYfield)
            LY.(myfield) = LXfield;
          elseif ismatrix(LYfield)
            n = numel(LXfield(:,ik)); m = size(LY.(myfield),1);
            if n>m, LY.(myfield) = [LY.(myfield);repmat(defaultvalue, n-m,size(LY.(myfield),2))]; end % extend original LY field with nans
            LY.(myfield)(:,k(ik)) = [LXfield(:,ik);repmat(defaultvalue, m-n,1)]; % pad with NaNs
          elseif ndims(LYfield) == 3
            LY.(myfield)(:,:,k(ik)) = LXfield(:,:,ik);
          elseif ndims(LYfield) == 4
            LY.(myfield)(:,:,:,k(ik)) = LXfield(:,:,:,ik);
          else            
            error('don''t know what to do');
          end
        end
    end
  end
end
