function dim = meqsize(L,fieldname)
% dim = meqsize(L,fieldname)
% Returns the dimension of some standard LY/LX fields
% 
% e.g. L = liu('tcv',61400,1); dim = meqsize(L,'Iv');
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

switch fieldname
  case 'Fx'
    dim = [L.nzx, L.nrx];
  case 'Fz'
    dim = [L.nzz, L.nrz];
  case {'rB','zB','FB','rA','zA','FA','qA','lX','dr2FA','dz2FA','drzFA','F0','F1',}
    dim = [L.nD 1];
  case {'q95','lp','rbary','FR'}
    dim = [L.nD, 1];
  case {'Iy','Opy'}
    dim = [L.nzy, L.nry];
  case {'IpD','zIpD','rIpD','rYD','zYD','WkD','WpD','WtD','Wt0D','WND','VpD','FtD','Ft0D','bpD','btD','liD','IniD'}
    dim = [L.nD,1];
  case {'Ia','Va','Tarel','Iarel'}
    dim = [L.G.na,1];
  case 'Iv'
    dim = [L.G.nv,1];
  case 'Iu'
    dim = [L.G.nu,1];
  case 'Is'
    if isfield(L.G,'ns'), ns = L.G.ns;
    elseif strcmp(L.P.selu(1),'s'), ns = L.G.nu;
    else, error('can''t determine ''s'' dimension');
    end
    dim = [ns,1];
  case {'PpQ','TTpQ','PQ','TQ','iTQ','iqQ','jtorQ','IpQ','VpQ','FtPQ'}
    dim = [L.nQ,L.nD];
  case {'PpQg','TTpQg'}
    dim = [L.nQ,L.nD,L.ng];
  case {'Ip','rBt','Wk','Wp','Wt','Wt0','WN','Vp','Ft','Ft0','bp','bt','mu','li','bpli2','Xt'}
    dim = [1,1];
  case {'lB','nA','nB','nX','raqmin','qmin','dz','dzg','rY','zY','zIp','rIp'}
    dim = [1,1];
  case {'rgeom','zgeom','kappa','delta','deltau','deltal','aminor','epsilon'}
    dim = [L.nQ,L.nD];
  case {'rrmax','zrmax','rrmin','zrmin','rzmax','zzmax','rzmin','zzmin'}
    dim = [L.nQ,L.nD];
  case {'Q0Q','Q1Q','Q2Q','Q3Q','Q4Q','ItQ','LpQ','rbQ','Q5Q','VQ','AQ','SlQ'}
    dim = [L.nQ,L.nD];
  case {'IpVQ','FtPVQ','rhotornorm'}
    dim = [L.nQ,L.nD];
  case {'raQ'}
    dim = [L.nQ, 1];
  case {'Bm','Um'}
    dim = [L.G.nm,1];
  case {'Ff','Uf'}
    dim = [L.G.nf,1];
  case {'TpDg','ITpDg'}
    dim = [L.nD,L.ng];
  case 'ag'
    dim = [L.ng,1];
  case {'Fn','Brn','Bzn','Brrn','Bzrn','Bzzn','Brzn','Un'}
    dim = [L.nn,1];
  case {'aW'}
    dim = [L.G.nW,L.P.nFW];
  case 'FW'
    dim = [1,L.P.nFW];
  case 'raR'
    dim = [L.nR,L.P.naR];
  case {'rS','zS'}
    dim = [L.noq,L.nS,L.nD];
  case {'niter','isconverged','res','t','shot','rst','cycle','err','resy','resFx','resC','resp','rese'}
    dim = [1,1];
  case {'Fe','Fedot','Ie'}
    dim = [L.ne,1];
  case {'aq','rq','zq'}
    dim = [L.noq,L.npq,L.nD];
  case {'rX','zX','FX','dr2FX','dz2FX','drzFX'}
    dim = [L.dimw,1];
  otherwise
    error('%s dimension not known', fieldname);
end
end
