function [dPpQdag,dTTpQdag,dPQdag,dTQdag,diTQdag,...
          dPpQdF0,dTTpQdF0,dPQdF0,dTQdF0,diTQdF0,...
          dPpQdF1,dTTpQdF1,dPQdF1,dTQdF1,diTQdF1] = ...
           meqprofJac(fPg,fTg,ag,FN,F0,F1,rBt,bfct,bfp,idsx,smalldia)
% MEQPROFJAC Computes jacobian of profiles from basis functions and fitting parameters
%
% See also MEQPROF
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

if nargin<11
  smalldia=false; % use small diamagnetic approximation optionally
end
ng = numel(ag);
nQ = numel(FN);
nD = numel(F0);

% Derivatives with respect to ag
[ gQg, IgQg          ] = bfct(2,bfp,FN,F0,F1);
[aPpg,aTTpg,aPg,ahqTg] = bfct(3,bfp,ones(ng,1),F0,F1,fPg,fTg,idsx);
gQg  = reshape( gQg,[nQ,nD,ng]);
IgQg = reshape(IgQg,[nQ,nD,ng]);
dPpQdag  =  gQg.*reshape( aPpg,[1,1,ng]);
dTTpQdag =  gQg.*reshape(aTTpg,[1,1,ng]);
dPQdag   = IgQg.*reshape(  aPg,[1,1,ng]);
dhqTQdag = IgQg.*reshape(ahqTg,[1,1,ng]);

% Derivatives with respect to F0/F1
[~, dgQgdF0, dgQgdF1,...
 ~,dIgQgdF0,dIgQgdF1] = bfct(12,bfp,FN,F0,F1); % TODO: fix size of outputs for single domain bfs
[daPpgdF0,daTTpgdF0,daPgdF0,dahqTgdF0,...
 daPpgdF1,daTTpgdF1,daPgdF1,dahqTgdF1] = bfct(13,bfp,ag,F0,F1,fPg,fTg,idsx);
dPpQdF0  = reshape(sum( gQg.*reshape( daPpgdF0,[1,1,ng,nD])+reshape( dgQgdF0,[nQ,nD,ng,nD]).*reshape( aPpg.*ag,1,1,ng),3),[nQ,nD,nD]);
dTTpQdF0 = reshape(sum( gQg.*reshape(daTTpgdF0,[1,1,ng,nD])+reshape( dgQgdF0,[nQ,nD,ng,nD]).*reshape(aTTpg.*ag,1,1,ng),3),[nQ,nD,nD]);
dPQdF0   = reshape(sum(IgQg.*reshape(  daPgdF0,[1,1,ng,nD])+reshape(dIgQgdF0,[nQ,nD,ng,nD]).*reshape(  aPg.*ag,1,1,ng),3),[nQ,nD,nD]);
dhqTQdF0 = reshape(sum(IgQg.*reshape(dahqTgdF0,[1,1,ng,nD])+reshape(dIgQgdF0,[nQ,nD,ng,nD]).*reshape(ahqTg.*ag,1,1,ng),3),[nQ,nD,nD]);
dPpQdF1  = reshape(sum( gQg.*reshape( daPpgdF1,[1,1,ng,nD])+reshape( dgQgdF1,[nQ,nD,ng,nD]).*reshape( aPpg.*ag,1,1,ng),3),[nQ,nD,nD]);
dTTpQdF1 = reshape(sum( gQg.*reshape(daTTpgdF1,[1,1,ng,nD])+reshape( dgQgdF1,[nQ,nD,ng,nD]).*reshape(aTTpg.*ag,1,1,ng),3),[nQ,nD,nD]);
dPQdF1   = reshape(sum(IgQg.*reshape(  daPgdF1,[1,1,ng,nD])+reshape(dIgQgdF1,[nQ,nD,ng,nD]).*reshape(  aPg.*ag,1,1,ng),3),[nQ,nD,nD]);
dhqTQdF1 = reshape(sum(IgQg.*reshape(dahqTgdF1,[1,1,ng,nD])+reshape(dIgQgdF1,[nQ,nD,ng,nD]).*reshape(ahqTg.*ag,1,1,ng),3),[nQ,nD,nD]);

% T and its inverse
irBt = 1./rBt;
if smalldia
  % small diamagnetic approximation
  % TQ =   rBt +      irBt*hqTQ; 
  dTQdag = irBt*dhqTQdag;
  dTQdF0 = irBt*dhqTQdF0;
  dTQdF1 = irBt*dhqTQdF1;
  % iTQ = irBt - (irBt*irBt*irBt)*hqTQ;
  mirBt3 = -(irBt*irBt*irBt);
  diTQdag = mirBt3*dhqTQdag;
  diTQdF0 = mirBt3*dhqTQdF0;
  diTQdF1 = mirBt3*dhqTQdF1;
else
  hqTQ = sum(dhqTQdag.*reshape(ag,[1,1,ng]),3);
  qTQ = 2*hqTQ+rBt*rBt;
  TQ = sign(rBt)*sqrt(qTQ);
  dTQdag = dhqTQdag./TQ;
  dTQdF0 = dhqTQdF0./TQ;
  dTQdF1 = dhqTQdF1./TQ;
  % iTQ = 1./TQ;
  miqTQ = -1./qTQ;
  diTQdag = dTQdag.*miqTQ;
  diTQdF0 = dTQdF0.*miqTQ;
  diTQdF1 = dTQdF1.*miqTQ;
end

end
