function [PpQ,TTpQ,PQ,TQ,iTQ,PpQg,TTpQg] = meqprof(fPg,fTg,ag,FN,F0,F1,rBt,bfct,bfp,idsx,smalldia)
% MEQPROF Computes profiles from basis functions and fitting parameters
% function [PpQ,TTpQ,PQ,TQ,iTQ,PpQg,TTpQg] = meqprof(fPg,fTg,ag,FN,F0,F1,rBt,bfct,bfp,idsx,smalldia)
% -
% INPUTS
% fPg, fTg : basis function assignment flags (see BFHELP)
% ag       : basis function coefficients
% FN       : Normalized flux on Q grid = L.pQ^2;
% F0, F1   : Axis, boundary flux
% rBt      : Vacuum R*Bt
% bfct, bfp: basis function handle and parameters (see BFHELP)
% idsx     : 1/(drx*dzx) = 1/(grid element surface)
% smalldia : use small diamagnetism approximation  for TQ computation
% - 
% OUTPUTS
% PpQ,TTpQ  :  pprime and TTprime. 
% PQ,TQ     :  Their primitives, assuming P(1)=0, T(1)=rBt
% iTQ       :  1/TQ,
% PpQg,TTpQg:  Contributions of each basis function to PpQ and TTpQ.
% The grid Q has associated L.pQ: the value of rhopsi=sqrt((Fx-F0)/(F1-F0)).
% See also BFHELP. For details, see [MEQ-redbook] documentation.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

if nargin<11
  smalldia=false; % use small diamagnetic approximation optionally
end
ng = numel(ag);
nQ = numel(FN);
nD = numel(F0);

% Computes profiles from basis functions
[ gQg, IgQg          ] = bfct(2,bfp,FN,F0,F1);
[aPpg,aTTpg,aPg,ahqTg] = bfct(3,bfp,ag,F0,F1,fPg,fTg,idsx);
gQg  = reshape( gQg,[nQ,nD,ng]);
IgQg = reshape(IgQg,[nQ,nD,ng]);
PpQg  =      gQg.*reshape( aPpg,1,1,ng)   ;
TTpQg =      gQg.*reshape(aTTpg,1,1,ng)   ;
PpQ   = sum( PpQg                      ,3);
TTpQ  = sum(TTpQg                      ,3);
PQ    = sum(IgQg.*reshape(  aPg,1,1,ng),3);
hqTQ  = sum(IgQg.*reshape(ahqTg,1,1,ng),3);

if nargout>3
  irBt = 1./rBt;
  if smalldia
    TQ =   rBt +      irBt*hqTQ; % small diamagnetic approximation
    iTQ = irBt - (irBt*irBt*irBt)*hqTQ;
  else
    TQ = sign(rBt)*sqrt(2*hqTQ+rBt*rBt);
    iTQ = 1./TQ;
  end
end
end
