function varargout = meqplotevo(L,varargin)
%MEQPLOTEVO Plot time evolution of meq LY structures
% meqplotevo(L,LY1,LY2,LY3,'parameter',value)
% Optional parameters inputs:
%   argplot: Cell array with LY fields to plot
%   legstr:  Cell array with strings for legend
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

varargins = {};

assert(nargin>1,'insufficient arguments')
for ii=1:numel(varargin)
  if isstruct(varargin{ii})
    LYs{ii} = varargin{ii}; %#ok<AGROW>
  else
    varargins = varargin(ii:end);
    break
  end
end

if L.P.idoublet, Ip='IpD'; else, Ip='Ip'; end

iP = inputParser; % initialize parser
addParameter(iP,'argplot',{'Ia','Va',Ip,'zA','rA','Wk','bp','bt','li','qA'})
addParameter(iP,'legstr',{''});
parse(iP,varargins{:}); % parse the inputs, input xyz is now available in P.xyz
P = iP.Results;

% plot and compare evolution of time-varying meq LY results
np = numel(P.argplot); % number of plots
nc = 2; nr = ceil(np/nc); % rows/columns of plots

clf; hax = zeros(nr,nc);
for ii = 1 : np
  hax(ii) = subplot(nr,nc,ii);
end
nLY = numel(LYs);


cols = get(gca,'ColorOrder');

for iLY = 1:nLY
  LY = LYs{iLY};
  assert(numel(LY.t)>1,'need multiple time slices for meqplotevo')
  col = cols(iLY,:);
 
  for iplot=1:np
    ax = hax(iplot);
    
    myplot = P.argplot{iplot};
 
    if isfield(LY,myplot)
      t = LY.t;
      data = LY.(myplot);
      if size(data,2)==1, t=1; end
      plot(ax,t,data,'Color',col);
      hold(ax,'on');
    end
    
    title(ax,myplot)
  end
end
linkaxes(hax,'x');
set(hax(1),'XLim',[t(1),t(end)]);
if ~isempty(P.legstr)
  legend(P.legstr)
end

if nargout==1
  varargout=hax;
end
end
