function meqplotD(L,LY,varargin)
% meqplotD(L,LY,LY2..)
% Plot droplet evolution
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

LYs{1} = LY; % in cell
for ii=1:numel(varargin)
  if isstruct(varargin{ii})
    LYs{1+ii} = varargin{ii};
  else
    %varargin = varargin(ii:nargin); break; % later opts
  end
end

cols = get(gca,'ColorOrder');
for iLY = 1:numel(LYs)
  col = cols(iLY,:);

  LY = LYs{iLY};
  % Totals
  subplot(221); plot(LY.t,LY.Ip/1e3); title('Ip [kA]'); hold on;
  
  % Per domain
  for iD=1:max(LY.nB)
    switch iD
      case 1, sty='-' ;
      case 2, sty='--';
    end
   
    subplot(222); plot(LY.t,LY.IpD(iD,:)/1e3,'LineStyle',sty,'color',col); hold on;
    title('IpD [kA]')
    
    if iD<LY.nA
      subplot(223); plot(LY.t,LY.rA(iD,:),'LineStyle',sty,'color',col); hold on;
      title('r'); ylim([min(L.G.rv),max(L.G.rv)]);
      
      subplot(224); plot(LY.t,LY.zA(iD,:),'LineStyle',sty,'color',col); hold on;
      title('z'); ylim([min(L.G.zv),max(L.G.zv)]);
    end
  end
end
end