function P = meqpfile(~,varargin)
% Default parameters for file tokamak
% 
% pfile
% gfile
% xfile
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Load pfile specified in input
for k = 1:2:numel(varargin)
  if strcmp(varargin{k},'pfile')
    P = load(varargin{k+1});
    break
  end
end

% Defaults
P.tok = 'file';
P.pfile = '';
P.gfile = '';
P.xfile = '';

% Overwrites
for k = 1:2:numel(varargin)
  P.(varargin{k}) = varargin{k+1};
end

end
