%MEQMDSSERVER Get and set MDS server
% server = meqmdsserver(newserver)
%
% Change the MDS server eg: meqmdsserver('myhost.mynet.my:8000');
% If no parameter given, returns the present name eg: name = meqmdsserver()
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function server = meqmdsserver(newserver)
  persistent meq_mds_server;
  if nargin>0
    meq_mds_server = newserver;
  else
    if (isempty(meq_mds_server))
      meq_mds_server = 'tcvdata.epfl.ch';
    end
  end
  server = meq_mds_server;
end
