%MEQMDSOPEN(SHOT,TREE[,BRANCH])
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function meqmdsopen(shot,tree,branch,server)
 if ~(nargin == 4 && ~isempty(server))
   server = meqmdsserver();
 end

 assert(~isempty(which('mdsopen')),'MEQ:NoMDS','mdsopen not found, are mds tools installed?')
 assert(logical(mdsconnect(server)),'Can not connect to %s mdsplus server',server)
 assert(~isempty(mdsopen(tree,shot)),'Can not open shot %s #%d',tree,shot);
 if nargin == 3 && ~isempty(branch)
  assert(isodd(mdssetdef(branch)),'Can not select branch %s',branch);
 end
end