%MEQLD  Selects ld script for MEQ
% MEQLD(MODE) selects the appropriate ld script for MEQ usage. MODE is
% either 'host' or 'target'. Called by RTWMAKECFG, built with MKCSF.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function f = meqld(mode)
 switch mode
  case 'host'
   switch computer
    case 'GLNXA64', f = 'meqld.lib';
   end
  case 'target'
   f = 'meqldrt.lib';
 end
end