function LY = meqik(LY,k,LX)
%MEQIK Insert time slice into LX/LY structure
%
% LY = meqik(LY,k,LX)
%  Inserts LX slice(s) into LY starting at index k;
%  LX can have an arbitrary number of times.
%  All data is inserted after index k
%  k must be a scalar or a logical index with one true entry
%  As this uses meqlpack, arrays are padded with NaNs when necessary
%
%
%  See also MEQXK, MEQSK, MEQLPACK
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

assert( islogical(k)&&(sum(k)==1) || (numel(k)==1),'k must be scalar or a logical index with only one true entry')
fieldnamediff = setdiff(fieldnames(LY),fieldnames(LX));
assert( isempty(fieldnamediff),'meqik:NotSameFields',...
  'Structures must have the same fields for insertion using meqik.');

% unpack LY
LYu = repmat(meqxk(LY,1),1,numel(LY.t)); % init
for ii=2:numel(LY.t)
  LYu(ii) = meqxk(LY,ii);
end

% unpack LX
LXu = repmat(meqxk(LX,1),1,numel(LX.t)); % init
for ii=2:numel(LX.t)
  LXu(ii) = meqxk(LX,ii);
end

% Insert LX starting at index k
LYu = [LYu(1:k-1),LXu,LYu(k:end)];

% pack
LY = meqlpack(LYu);
if isfield(LX,'tokamak')
  LY.tokamak = LX.tokamak;
end

end
