function ag=meqfitprof(L,FN,F0,F1,PpQ,TTpQ)
%function ag = meqfitprof(L,FN,F0,F1,PpQ,TTpQ)
% fit PpQ,TTpQ profiles with ag coefficients
% FN: normalized flux radial coordinate
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

nt = size(F0,2);

if ~any(PpQ(:)) && ~any(TTpQ(:))
  ag = zeros(L.ng,nt);
  return
end

if isequal(func2str(L.bfct),'bffbt') && size(L.bfp,2)>1
  assert(~any(any(diff(L.bfp,[],2))),'time-varying bfp non supported');
end

npQ = numel(FN); % number of data points
% find ag that fits PpQ,TTpQ profiles
ag  = ones(L.ng,nt);
ago = ones(L.ng, 1); % ones just to get scaling
for kt=1:nt
  [gN]       = L.bfct(2,L.bfp,FN,F0(:,kt),F1(:,kt));
  % get scaling between ag=1 and p',TT' equation scaling
  [aPp,aTTp] = L.bfct(3,L.bfp,ago,F0(:,kt),F1(:,kt),L.fPg,L.fTg,L.idsx);
  % fit ag coefficients to desired p',TT'
  if L.nD == 1
    ag(:,kt) = [gN.*aPp';gN.*aTTp']\[PpQ(:,kt);TTpQ(:,kt)];
  else
    % build single least-squares problem for all ag based on profiles in all
    % all domains profiles
    ndd = 2*npQ*L.nD;   % data points to fit
    A = zeros(ndd,L.ng); % init
    b = zeros(0,1);
    for iD=1:L.nD
      ind = (iD-1)*2*npQ + (1:(2*npQ));
      gND = squeeze(gN(:,iD,:));
      A(ind,:) = [gND.*aPp';gND.*aTTp'];
      b(ind,1) = [PpQ(:,iD,kt);TTpQ(:,iD,kt)];
    end
    % catch cases where some domains have no contribution from ag to avoid rank warnings
    icstr = any(A,1); % these ag entries are constrained by the LSQ problem
    ag( icstr,kt) = A(:,icstr)\b;
    ag(~icstr,kt) = 0; % set others to zero
  end
end
end