%MEQFBP  Plasma contribution to boundary condition for Poisson solver
% FB = MEQFBP(IY,L) returns the contribution from the plasma current
% distribution IY to the boundary condition for the Poisson solver. L
% contains ancillary data obtained with LIUC. See also GSZRMEX,MEQMESH.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function Fb = meqfbp(Iy,L)
  if L.P.ilackner == 1
    % Normal flux derivative on boundary approximation: dF(x)/dx = (4F(x+dx)-F(x+2dx)-3(F(x)=0))/(2dx)
    Iy = reshape(Iy,L.nzy,L.nry,[]);
    Fb = L.Tbc*nfdbmex(gszrmex(zeros(2*(L.nzx+L.nrx-2),size(Iy,3)),Iy,L.cx,L.cq,L.cr,L.cs,L.ci,L.co,0));
  else
    Iy = reshape(Iy,L.ny,[]);
    if issparse(Iy)
      % This helps keep the sparse nature of the jacobian for algoNL=Newton-GS
      Fb = sparse(L.Mby) * Iy;
    else
      Fb =        L.Mby  * Iy;
    end
  end
end